$(document).ready(function() {		
		
/**********************************************************************************************
* Days-Hours-Minutes-Seconds Counter script by Praveen Lobo
* (http://PraveenLobo.com/techblog/javascript-counter-count-days-hours-minutes-seconds/)
* This notice MUST stay intact(in both JS file and SCRIPT tag) for legal use.
* http://praveenlobo.com/blog/disclaimer/
**********************************************************************************************/

function DaysHMSCounter(initDate, id){
    this.counterDate = new Date(initDate);
    this.container = document.getElementById("countdown");
    this.update();
}
 
DaysHMSCounter.prototype.calculateUnit=function(secDiff, unitSeconds){
    var tmp = Math.abs((tmp = secDiff/unitSeconds)) < 1? 0 : tmp;
    return Math.abs(tmp < 0 ? Math.ceil(tmp) : Math.floor(tmp));
}
 
DaysHMSCounter.prototype.calculate=function(){
    var secDiff = Math.abs(Math.round(((new Date()) - this.counterDate)/1000));
    this.days = this.calculateUnit(secDiff,86400);
    this.hours = this.calculateUnit((secDiff-(this.days*86400)),3600);
    this.mins = this.calculateUnit((secDiff-(this.days*86400)-(this.hours*3600)),60);
    this.secs = this.calculateUnit((secDiff-(this.days*86400)-(this.hours*3600)-(this.mins*60)),1);
}
 
DaysHMSCounter.prototype.update=function(){
    this.calculate();
    this.container.innerHTML =
	
        "<h3>" + this.days  +"</h3><h4>"+ (this.days == 1? " day " : " days ") +"</h4>"+
        "<h3>" + this.hours +"</h3><h4>"+ (this.hours == 1?" hour " : " hours ") +"</h4>"+
        "<h3>" + this.mins  +"</h3><h4>"+ (this.mins == 1? " min " : " mins ") +"</h4>"+
        "<h3>" + this.secs  +"</h3><h4>"+ (this.secs == 1? " sec " : " secs ") +"</h4>";
    var self = this;
    setTimeout(function(){self.update();}, (1000));
}
 
    new DaysHMSCounter('December 22, 2020 10:00:00', 'counter'); 

			
});